/* 
 * sigaction.c 
 *
 * Виводить відповідне повідомлення, коли отримує сигнал SIGTERM,
 * і ігнорує при цьому сигнал SIGINT.
 * Ілюструє порядок організації асинхронної обробки сигналів
 * (функція sigaction()).
 *
 */

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


/* Обробник сигналу SIGTERM */
void sigterm_handler(int signo)
{
        write(STDOUT_FILENO, "Отримано сигнал SIGTERM.\n", 38);
        _exit(EXIT_FAILURE);
}

int main()
{
        struct sigaction act;
        int i;

        printf("Привіт, мій PID дорівнює %d.\n", (int) getpid());

        /* Оголошує ігнорування сигналу SIGINT. */
        memset(&act, 0, sizeof(act));
        act.sa_handler = SIG_IGN;
        if (sigaction(SIGINT, &act, NULL) != 0) {
                fprintf(stderr, "Помилка при спробі встановити диспозицію"
                                " сигналу SIGINT: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
        /* Визначає нову диспозицію для сигналу SIGTERM. */
        act.sa_handler = sigterm_handler;
        if (sigaction(SIGTERM, &act, NULL) != 0) {
                fprintf(stderr, "Помилка при спробі встановити диспозицію"
                                " сигналу SIGTERM: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        for (i = 1; ; i++) {
                sleep(3);
                printf("%d\n", i);
        }

        exit(EXIT_SUCCESS);
}
